import torch.optim as optim


def get_optimizer(full_package):
    config = full_package["config"]
    optimizer_type, learning_rate = (
        config["train"]["optimizer_type"],
        config["train"]["learning_rate"],
    )

    if optimizer_type == "sgd":
        opt_ = optim.SGD(
            full_package["model"].parameters(),
            lr=learning_rate,
            momentum=0.9,
            weight_decay=5e-4,
        )
    elif optimizer_type == "adam":
        opt_ = optim.Adam(
            full_package["model"].parameters(), lr=learning_rate, weight_decay=5e-4
        )
    elif optimizer_type == "rmsprop":
        opt_ = optim.RMSprop(full_package["model"].parameters(), lr=learning_rate)
    else:
        raise ValueError(f"Unsupported optimizer type: {optimizer_type}")

    full_package["optimizer"] = opt_


def get_scheduler(full_package):
    config = full_package["config"]
    scheduler_type = config["train"]["scheduler_type"]

    if scheduler_type == "step":
        scheduler_gamma, scheduler_step_size = (
            config["train"]["scheduler_gamma"],
            config["train"]["scheduler_step_size"],
        )
        scheduler = optim.lr_scheduler.StepLR(
            full_package["optimizer"],
            step_size=scheduler_step_size,
            gamma=scheduler_gamma,
        )
    elif scheduler_type == "cosine":
        scheduler_T_max = config["train"]["scheduler_T_max"]
        scheduler = optim.lr_scheduler.CosineAnnealingLR(
            full_package["optimizer"], T_max=scheduler_T_max
        )
    else:
        raise ValueError(f"Unsupported scheduler type: {scheduler_type}")
    full_package["scheduler"] = scheduler
